//
//  YHHKPlaceInfoCell.swift
//  galaxy
//
//  Created by edy on 2024/8/23.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKPlaceInfoCell: UITableViewCell {

    static let cellReuseIdentifier = "YHHKPlaceInfoCell"
    
    let selectTextColor = UIColor.mainTextColor
    let unselectTextColor = UIColor.mainTextColor(alpha: 0.3)
    let selectFont = UIFont.PFSC_M(ofSize: 14)
    let unselectFont = UIFont.PFSC_R(ofSize: 14)
    let selectBgColor = UIColor.init(hex: 0xF0F4FB)
    let unselectBgColor = UIColor.white
    
    func updateModel(_ model: YHMakeCertificatePlaceModel) {
        detailLabel.text = model.name
        detailLabel.textColor = model.isSelect ? selectTextColor : unselectTextColor
        detailLabel.font = model.isSelect ? selectFont : unselectFont
        whiteView.backgroundColor = model.isSelect ? selectBgColor : unselectBgColor
    }
    
    lazy var whiteView: UIView = {
        let view = UIView()
        view.backgroundColor = unselectBgColor
        view.layer.cornerRadius = 3.0
        return view
    }()
    
    lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.textColor = self.unselectTextColor
        label.font = self.unselectFont
        return label
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        
        contentView.addSubview(self.whiteView)
        self.whiteView.addSubview(detailLabel)
        
        whiteView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        detailLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(12)
            make.bottom.equalTo(-12)
        }
    }

}
